<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../gUtil/DbManager.php";
    include "../../gUtil/GestoreUpload.php";
    include "../../gUtil/ControlloreStringhe.php";
    include "../../gUtil/ElaboratoreImmagini.php";
    include "../../classi/GeneratoreUrl.php";
    include "../../classi/ecommerce/BuonoSconto.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $datiGeecomCms = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $urlAreaAmministrativa = GeneratoreUrl::creaUrlAreaAmministrativa(recuperaImpostazioni($geecomDb), $datiGeecomCms);
            
    if(isset($_GET["operazione"])) {
	$operazione   = filter_input(INPUT_GET, "operazione", FILTER_SANITIZE_STRING);
	$idBuonoSconto = filter_input(INPUT_GET, "id", FILTER_SANITIZE_NUMBER_INT);
    }
    else {
	$operazione   = filter_input(INPUT_POST, "operazione", FILTER_SANITIZE_STRING);
	$idBuonoSconto = (isset($_POST["id"])) ? filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT) : 0;
    }
    $buonoSconto = new BuonoSconto($geecomDb, $idBuonoSconto);
    
    if($operazione=="elimina") {
        $buonoSconto->elimina();
        echo "ok";
    }
    else if($operazione=="crea") {
        $buonoSconto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
        $buonoSconto->setCodice(filter_input(INPUT_POST,"codice",FILTER_SANITIZE_STRING));
        $buonoSconto->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
        $buonoSconto->setAmmontare(filter_input(INPUT_POST,"ammontare",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $buonoSconto->setBuoniRimanenti(filter_input(INPUT_POST,"buoniRimanenti",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setProdottiInteressati(filter_input(INPUT_POST,"prodottiInteressati",FILTER_SANITIZE_STRING));
        $buonoSconto->setSpesaMinima(filter_input(INPUT_POST,"spesaMinima",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $buonoSconto->setLimitePerPersona(filter_input(INPUT_POST,"limitePerPersona",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setProdotto(filter_input(INPUT_POST,"singoloProdotto",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setDataScadenza(filter_input(INPUT_POST,"dataScadenza",FILTER_SANITIZE_STRING));
        $idBuonoSconto = $buonoSconto->crea();
        header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaBuonoSconto.php?id=$idBuonoSconto&status=200");
    }
    else if($operazione=="modifica") {
        $buonoSconto->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
        $buonoSconto->setCodice(filter_input(INPUT_POST,"codice",FILTER_SANITIZE_STRING));
        $buonoSconto->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
        $buonoSconto->setAmmontare(filter_input(INPUT_POST,"ammontare",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $buonoSconto->setBuoniRimanenti(filter_input(INPUT_POST,"buoniRimanenti",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setProdottiInteressati(filter_input(INPUT_POST,"prodottiInteressati",FILTER_SANITIZE_STRING));
        $buonoSconto->setSpesaMinima(filter_input(INPUT_POST,"spesaMinima",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
        $buonoSconto->setLimitePerPersona(filter_input(INPUT_POST,"limitePerPersona",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setProdotto(filter_input(INPUT_POST,"singoloProdotto",FILTER_SANITIZE_NUMBER_INT));
        $buonoSconto->setDataScadenza(filter_input(INPUT_POST,"dataScadenza",FILTER_SANITIZE_STRING));
        $buonoSconto->modifica();
        header("Location: $urlAreaAmministrativa/componenti/ecommerce/creaBuonoSconto.php?id={$buonoSconto->getId()}&status=220");
    }
